<?php


namespace Mainto\Api\WorkOrder\WorkOrder\DTO\WorkOrderDTO;


use Mainto\RpcServer\RpcAnnotations\RpcComment;
use Mainto\RpcServer\RpcServer\RpcObject;

/**
 * Class DetailExtraDTO
 * @package Mainto\Api\WorkOrder\WorkOrder\DTO\WorkOrderDTO
 */
class ExtraDTO extends RpcObject {
    /**
     * @RpcComment(comment="部门id")
     * @var int|null
     */
    public ?int $departmentId = null;

    /**
     * @RpcComment(comment="附件 当前版本取消")
     * @var array<string>
     */
    public array $appendix;

    /**
     *
     * @RpcComment(comment="技术支持创建")
     * @var string
     */
    public string $referText;

    /**
     * @RpcComment(comment="客户端ip")
     * @var string
     */
    public string $clientIP;

    /**
     * @RpcComment(comment="反馈使用的账号")
     * @var int
     */
    public int $currentStaffId;

    /**
     * @RpcComment(comment="订单号")
     * @var string|null
     */
    public ?string $orderNo = null;

    /**
     * @RpcComment(comment="客户地址信息")
     * @var ExtraGeoInfoDTO|null
     */
    public ?ExtraGeoInfoDTO $clientGeoInfo = null;

    /**
     * @RpcComment(comment="完成工单备注")
     * @var FinishRemarkDTO|null
     */
    public ?FinishRemarkDTO $finishRemark = null;
}
