<?php


namespace Mainto\Api\WorkOrder\WorkOrder\DTO;


use Mainto\Api\WorkOrder\WorkOrder\DTO\WorkOrderDTO\ExtraDTO;
use Mainto\RpcServer\RpcAnnotations\RpcComment;
use Mainto\RpcServer\RpcServer\RpcObject;

/**
 * Class WorkOrderDTO
 * @package Mainto\Api\WorkOrder\WorkOrder\DTO
 */
class WorkOrderDTO extends RpcObject {

    /**
     * @RpcComment(comment="工单id")
     * @var int|null
     */
    public ?int $workOrderId = null;

    /**
     * @RpcComment(comment="反馈员工id")
     * @var int
     */
    public int $sender;

    /**
     * @RpcComment(comment="工单反馈内容")
     * @var string
     */
    public string $content;

    /**
     * @RpcComment(comment="工单分类id")
     * @var int
     */
    public int $categoryId;

    /**
     * @RpcComment(comment="来源域名")
     * @var string
     */
    public string $origin;

    /**
     * @RpcComment(comment="状态  created｜已创建  processing｜处理中  finished｜已完成")
     * @var string
     */
    public string $state;

    /**
     * @RpcComment(comment="创建时间")
     * @var string|null
     */
    public ?string $createdAt;

    /**
     * @RpcComment(comment="更新时间")
     * @var string|null
     */
    public ?string $updatedAt;

    /**
     * @RpcComment(comment="关联conding id ")
     * @var int|null
     */
    public ?int $codingId = null;

    /**
     * @RpcComment(comment="关联pingcode id ")
     * @var string|null
     */
    public ?string $pingCodeId = null;


    public ?ExtraDTO $extra = null;

    /**
     * @RpcComment(comment="跳转 coding url")
     * @var string
     */
    public string $codingUrl = "";

    /**
     * @RpcComment(comment="场景群id")
     * @var ?string
     */
    public ?string $chartGroupId = null;

    /**
     * @RpcComment(comment="跳转 pingCode url")
     * @var string
     */
    public string $pingCodeUrl = "";

    /**
     * @RpcComment(comment="当前处理人id")
     * @var int|null
     */
    public ?int $currentAcceptorId = null;
}
