<?php


namespace Mainto\Api\WorkOrder\WorkOrder\Cmd;

use Mainto\RpcServer\RpcAnnotations\RpcComment;
use Mainto\RpcServer\RpcAnnotations\RpcValidation;
use Mainto\RpcServer\RpcServer\RpcObject;

/**
 * Class ListDTO
 * @package Mainto\Api\WorkOrder\WorkOrder\Http\DTO
 */
class ListCmd extends RpcObject{
    public int $page;

    public int $pageSize;

    /**
     * @RpcComment(comment="array状态: WorkOrderStateEnum")
     * @var array
     */
    public array $stateArr = [];

    /**
     * @var bool
     */
    public bool $desc = true;

    /**
     * @RpcComment(comment="array分类: WorkOrderCategoryEnum")
     * @var array
     */
    public array $categoryIdArr = [];

    /**
     * @RpcComment(comment="创建时间-起")
     * @RpcValidation(validation="date_format:Y-m-d")
     */
    public string $createdAtStart = "";

    /**
     * @RpcComment(comment="创建时间-止")
     * @RpcValidation(validation="date_format:Y-m-d")
     */
    public string $createdAtEnd = "";
}
