<?php


namespace Mainto\Api\WorkOrder\WorkOrder\Cmd;

use Mainto\RpcServer\RpcAnnotations\RpcComment;
use Mainto\RpcServer\RpcAnnotations\RpcValidation;
use Mainto\RpcServer\RpcAnnotations\RpcValueFromHeader;
use Mainto\RpcServer\RpcAnnotations\RpcValueFromSession;
use Mainto\RpcServer\RpcServer\RpcObject;

/**
 * Class StartDto
 * @package App\Domain\WorkOrder\Dto
 */
class CreateCmd extends RpcObject {
    /**
     * @RpcValueFromSession(key="manage_staffid")
     * @RpcComment(comment="当前登录账号Id")
     */
    public int $currentStaffId;

    /**
     * @RpcComment(comment="反馈人Id")
     * @RpcValidation(validation="existsStaffId")
     */
    public ?int $reportStaffId = null;

    /**
     * @RpcValueFromSession(key="manage_storeid")
     * @RpcComment(comment="当前登录选择的门店")
     */
    public int $currentStoreId = 0;

    /**
     * @RpcComment(comment="咨询内容")
     * @var string
     */
    public string $content;

    /**
     * @RpcComment(comment="附件")
     * @var array
     */
    public array $appendix = [];

    /**
     * @RpcComment(comment="问题分类(默认0)")
     * @RpcValidation(validation="exclude_if:categoryId,=,0|exists:work_order_categories,id")
     * @var int
     */
    public int $categoryId = 0;

    /**
     * @RpcComment(comment="反馈来源域名 location.host")
     * @RpcValidation(validation="max:128|origin")
     * @var string
     */
    public string $origin;

    /**
     * @RpcComment(comment="反馈来源中文描述")
     * @var string
     */
    public string $referText;

    /**
     * @RpcValueFromHeader(key="X-Real-Ip")
     * @var string
     */
    public string $clientIP;

    /**
     * @var string|null
     */
    public ?string $orderNo = null;
}
