<?php

namespace Mainto\Api\WorkOrder\WorkOrder\Cmd;

use Mainto\RpcServer\RpcAnnotations\RpcComment;
use Mainto\RpcServer\RpcAnnotations\RpcValidation;
use Mainto\RpcServer\RpcAnnotations\RpcValueFromSession;
use Mainto\RpcServer\RpcServer\RpcObject;

class CreateByAdminCmd extends RpcObject {
    /**
     * @RpcValueFromSession(key="manage_staffid")
     * @RpcComment(comment="创建人")
     */
    public int $admin;

    /**
     * @RpcComment(comment="反馈人Id")
     * @RpcValidation(validation="existsStaffId")
     */
    public int $sender;

    /**
     * @RpcComment(comment="咨询内容")
     * @var string
     */
    public string $content;

    /**
     * @RpcComment(comment="附件")
     * @var array
     */
    public array $appendix = [];

    /**
     * @RpcComment(comment="问题分类(默认0)")
     * @RpcValidation(validation="exclude_if:categoryId,=,0|exists:work_order_categories,id")
     * @var int
     */
    public int $categoryId = 0;

    /**
     * @RpcComment(comment="反馈来源域名 location.host")
     * @RpcValidation(validation="max:128|origin")
     * @var string
     */
    public string $origin;

    /**
     * @var string|null
     */
    public ?string $orderNo = null;
}
