<?php

namespace Mainto\Api\WorkOrder;

use Illuminate\Support\ServiceProvider as BaseServiceProvider;
use Mainto\Api\WorkOrder\WorkOrder\Api\WorkOrderApi;
use Mainto\Api\WorkOrder\WorkOrder\Api\WorkOrderIssueApi;
use Mainto\RpcServer\RpcServer\RpcRouter;

class ServiceProvider extends BaseServiceProvider {
    public function boot () {

    }

    public function register () {
        $this->app->get('config')->set('rpc-server.service_name', 'WorkOrder');
        $this->app->get('config')->set('rpc-server.service_alias', '工单服务');

        $router = RpcRouter::getInstance();

        $router->register(WorkOrderApi::class, "WorkOrder\WorkOrderController");
        $router->register(WorkOrderIssueApi::class, "WorkOrder\WorkOrderIssueController");
    }
}