<?php

namespace Mainto\Api\WorkOrder\WorkOrder\Cmd;

use Mainto\Api\WorkOrder\WorkOrder\Enum\IssueEnum;
use Mainto\RpcServer\RpcAnnotations\RpcComment;
use Mainto\RpcServer\RpcAnnotations\RpcValidation;
use Mainto\RpcServer\RpcServer\RpcObject;

class UpdateWorkOrderIssueCmd extends RpcObject {

    /**
     * @RpcComment(comment="问题id")
     */
    public int $issueId;

    /**
     * @RpcComment(comment="分类id")
     * @RpcValidation(validation="exists:work_order_issue_categories,id")
     */
    public int $issueCategoryId;

    /**
     * @RpcComment(comment="问题标题")
     * @RpcValidation("max:200")
     */
    public string $title;

    /**
     * @RpcComment(comment="问题标签")
     * @RpcValidation(validation="issueTags")
     */
    public array $tags;

    /**
     * @RpcComment(comment="问题答案")
     */
    public string $content;

    /**
     * @RpcComment(comment="问题答案")
     * @RpcValidation(validation="issueStatus")
     */
    public string $status = IssueEnum::DISABLED;
}
