<?php

namespace Mainto\Api\WorkOrder\WorkOrder\Api;

use Mainto\Api\WorkOrder\WorkOrder\Cmd\CreateWorkOrderIssueCmd;
use Mainto\Api\WorkOrder\WorkOrder\Cmd\IssueCategoryCreateCmd;
use Mainto\Api\WorkOrder\WorkOrder\Cmd\IssueCategoryUpdateCmd;
use Mainto\Api\WorkOrder\WorkOrder\Cmd\IssueListCmd;
use Mainto\Api\WorkOrder\WorkOrder\Cmd\SuggestListCmd;
use Mainto\Api\WorkOrder\WorkOrder\Cmd\UpdateWorkOrderIssueCmd;
use Mainto\Api\WorkOrder\WorkOrder\DTO\IssueListDTO;
use Mainto\Api\WorkOrder\WorkOrder\DTO\SuggestListDTO;
use Mainto\Api\WorkOrder\WorkOrder\DTO\WorkOrderIssueDTO;
use Mainto\RpcServer\RpcAnnotations\Alias;
use Mainto\RpcServer\RpcAnnotations\RpcApi;
use Mainto\RpcServer\RpcAnnotations\RpcAuthority;
use Mainto\RpcServer\RpcAnnotations\RpcParam;
use Mainto\RpcServer\Util\Types\Map;

interface WorkOrderIssueApi {

    /**
     * @Alias(name="问题库-列表")
     * @RpcApi(method="POST", url="/issue/list")
     * @RpcAuthority(need="manager.base")
     * @param IssueListCmd $issueListCmd
     * @return IssueListDTO
     */
    public function list (IssueListCmd $issueListCmd): IssueListDTO;

    /**
     * @Alias(name="问题库-推荐列表")
     * @RpcApi(method="POST", url="/issue/suggest_list")
     * @param SuggestListCmd $suggestListCmd
     * @return SuggestListDTO
     */
    public function suggestList (SuggestListCmd $suggestListCmd): SuggestListDTO;

    /**
     * @Alias(name="问题库-创建")
     * @RpcApi(method="POST", url="/issue/create")
     * @RpcAuthority(need="manager.base")
     * @param CreateWorkOrderIssueCmd $cmd
     * @return int
     */
    public function create (CreateWorkOrderIssueCmd $cmd): int;


    /**
     * @Alias(name="问题库-更新")
     * @RpcApi(method="POST", url="/issue/update")
     * @RpcAuthority(need="manager.base")
     * @param UpdateWorkOrderIssueCmd $cmd
     * @return int
     */
    public function update (UpdateWorkOrderIssueCmd $cmd): int;


    /**
     * @Alias(name="问题库-删除")
     * @RpcApi(method="POST", url="/issue/delete")
     * @RpcAuthority(need="manager.base")
     * @RpcParam(name="issueId", type="uint", comment="问题", require=true)
     * @param int $issueId
     * @return bool
     */
    public function delete (int $issueId): bool;

    /**
     * @Alias(name="问题库-详情")
     * @RpcApi(method="GET", url="/issue/detail")
     * @RpcAuthority(need="manager.base")
     * @RpcParam(name="issueId", type="uint", comment="问题", require=true)
     * @param int $issueId
     * @return WorkOrderIssueDTO|null
     */
    public function detail (int $issueId): ?WorkOrderIssueDTO;


    /**
     * @Alias(name="问题库分类-列表")
     * @RpcApi(method="GET", url="/issue/categories")
     * @RpcAuthority(need="manager.base")
     * @RpcParam(name="categoryName", type="string", comment="目录", require=false)
     * @param string $categoryName
     * @return Map<int, string>
     */
    public function categories (string $categoryName = ''): Map;

    /**
     * @Alias(name="问题库分类-删除")
     * @RpcApi(method="POST", url="/issue/category_delete")
     * @RpcParam(name="issueCategoryId", type="uint", comment="分类id", require=true)
     * @RpcAuthority(need="manager.base")
     * @param int $issueCategoryId
     * @return bool
     */
    public function issueCategoryDelete (int $issueCategoryId): bool;

    /**
     * @Alias(name="问题库分类-创建")
     * @RpcApi(method="POST", url="/issue/category_create")
     * @RpcAuthority(need="manager.base")
     * @param IssueCategoryCreateCmd $issueCategoryCmd
     * @return int
     */
    public function issueCategoryCreate (IssueCategoryCreateCmd $issueCategoryCmd): int;

    /**
     * @Alias(name="问题库分类-更新")
     * @RpcApi(method="PUT", url="/issue/category_update")
     * @RpcAuthority(need="manager.base")
     * @param IssueCategoryUpdateCmd $issueCategoryCmd
     * @return int
     */
    public function issueCategoryUpdate (IssueCategoryUpdateCmd $issueCategoryCmd): int;


}
