<?php

namespace Mainto\Websocket;

use Mainto\Websocket\Router\Router;
use Illuminate\Support\ServiceProvider;
use Mainto\Websocket\Contracts\Response as ResponseImp;

class WebSocketServiceProvider extends ServiceProvider
{
    protected $routes = [];

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton(Router::class, function () {
            return new Router(...$this->routes);
        });

        $this->app->alias(Router::class, 'ws_router');

        $this->app->bind(ResponseImp::class, Response::class);

        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__.'/config/ws.php' => config_path('ws.php'),
                __DIR__.'/config/route.php' => base_path('routes/ws.php')
            ]);
        }
    }

    public function boot()
    {
        $this->registerRoutePath(base_path('routes/ws.php'));
    }

    protected function registerRoutePath(...$path)
    {
        $this->routes = array_merge($this->routes, $path);
    }
}
