<?php

namespace Mainto\Websocket;

use Mainto\Websocket\Router\Router;
use Illuminate\Support\ServiceProvider;
use Mainto\Websocket\Console\RequestMakeCommand;
use Mainto\Websocket\Contracts\Response as ResponseImp;
use Mainto\Websocket\Auth\Console\WebsocketTableCommand;

class WebSocketServiceProvider extends ServiceProvider
{
    protected $routes = [];

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton(Router::class, function () {
            return new Router(...$this->routes);
        });

        $this->app->alias(Router::class, 'websocket.router');

        $this->app->bind(ResponseImp::class, Response::class);

        $this->app->alias(ResponseImp::class, 'websocket.response');

        $this->mergeConfigFrom(
            __DIR__ . '/config/ws.php',
            'ws'
        );

        if ($this->app->runningInConsole()) {
            $this->publishes([
                __DIR__ . '/config/ws.php'    => config_path('ws.php'),
                __DIR__ . '/config/route.php' => base_path('routes/ws.php'),
            ], 'ws');

            $this->commands([
                RequestMakeCommand::class,
                WebsocketTableCommand::class,
            ]);
        }
    }

    public function boot()
    {
        $this->registerRoutePath(base_path('routes/ws.php'));
    }

    protected function registerRoutePath(...$path)
    {
        $this->routes = array_merge($this->routes, $path);
    }
}
