<?php

namespace Mainto\Websocket\Contracts;

use Mainto\Websocket\Auth\User;

/**
 * Interface AuthGuard
 * @package Mainto\Websocket\Contracts
 */
interface AuthGuard
{
    /**
     * Get the ID for the currently authenticated user.
     *
     * @return string|null
     */
    public function uuid();

    /**
     * @return bool
     *
     * @author 神符 <1025434218@qq.com>
     */
    public function guest();

    /**
     * @return bool
     *
     * @author 神符 <1025434218@qq.com>
     */
    public function hasUser();

    /**
     * @return bool
     *
     * @author 神符 <1025434218@qq.com>
     */
    public function check();

    /**
     * @return Userable|null
     *
     * @author 神符 <1025434218@qq.com>
     */
    public function user();

    /**
     * @param Userable $user
     *
     * @author duc <1025434218@qq.com>
     */
    public function login(Userable $user);

    /**
     * @param Userable $user
     * @return bool
     *
     * @author duc <1025434218@qq.com>
     */
    public function isLogin(Userable $user);

    /**
     * @param Userable|null $user
     *
     * @author duc <1025434218@qq.com>
     */
    public function logout(Userable $user = null);

    /**
     * @param string $uuid
     * @return User|null
     *
     * @author duc <1025434218@qq.com>
     */
    public function getUserByUuid(string $uuid);

    /**
     * @param $key
     * @return string
     *
     * @author duc <1025434218@qq.com>
     */
    public function getUuidByKey($key);

    /**
     * @param string $uuid
     *
     * @author duc <1025434218@qq.com>
     */
    public function dissociate(string $uuid);

    /**
     * @return array
     *
     * @author duc <1025434218@qq.com>
     */
    public function getAllKeyUuid();

    /**
     * @return array
     *
     * @author duc <1025434218@qq.com>
     */
    public function getAllUuidUsers();
}
