<?php

namespace Mainto\Websocket\Contracts;

use Mainto\RpcServer\RpcServer\RpcContext;

/**
 * Interface Response
 * @package Mainto\Websocket\Contracts
 */
interface Response
{
    /**
     * @return Response
     *
     * @author 神符 <1025434218@qq.com>
     */
    public function atOnce(): Response;

    /**
     * @param RpcContext $context
     * @param $data
     * @param string $type
     * @param string $room
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function successBroadcast(RpcContext $context, $data, string $type = '', string $room = null);

    /**
     * @param RpcContext $context
     * @param $data
     * @param string $type
     * @param string $room
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function successToSelf(RpcContext $context, $data, string $type = '', string $room = null);

    /**
     * @param RpcContext $context
     * @param string $uuid
     * @param $data
     * @param string $type
     * @param string $room
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function successToUser(RpcContext $context, string $uuid, $data, string $type = '', string $room = null);

    /**
     * @param RpcContext $context
     * @param \Throwable $exception
     * @param array $appends
     * @param string $type
     * @param string $room
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function errorBroadcast(RpcContext $context, \Throwable $exception, array $appends = [], string $type = '', string $room = null);

    /**
     * @param RpcContext $context
     * @param \Throwable $exception
     * @param array $appends
     * @param string $type
     * @param string $room
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function errorToSelf(RpcContext $context, \Throwable $exception, array $appends = [], string $type = '', string $room = null);

    /**
     * @param RpcContext $context
     * @param string $uuid
     * @param \Throwable $exception
     * @param array $appends
     * @param string $type
     * @param string $room
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function errorToUser(RpcContext $context, string $uuid, \Throwable $exception, array $appends = [], string $type = '', string $room = null);

    /**
     * @param RpcContext $context
     * @param string $notifyType
     * @param string|null $uuid
     * @param array $payload
     * @param string $room
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function notifyUser(RpcContext $context, string $notifyType, string $uuid = null, array $payload = [], string $room = null);

    /**
     * @param RpcContext $context
     * @param string $notifyType
     * @param array $payload
     * @param string $room
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function notifyAll(RpcContext $context, string $notifyType, array $payload = [], string $room = null);

    /**
     * @param string $uuid
     * @param string $room
     * @param array $msg
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function sendToUser(string $uuid, string $room, array $msg);
}
