<?php

namespace Mainto\Websocket\Utils;

use Mainto\Websocket\CacheKey;
use Illuminate\Support\Facades\Redis;
use Mainto\Websocket\Auth\Models\User;

class WS
{
    /**
     * @param $key
     * @param string $room
     * @return string|null
     *
     * @author duc <1025434218@qq.com>
     */
    public static function getUuidByKey($key, string $room)
    {
        $driver = config('ws.auth.driver');

        $key = CacheKey::userKey($key);

        switch ($driver) {
            case 'redis':
                $uuidUserKey = CacheKey::keyUuidMap($room);
                $connection = config('ws.connection', 'default');

                return Redis::connection($connection)->hget($uuidUserKey, $key) ?? null;
            case 'mysql':
                return optional(User::query()->where('room', $room)->where('key', $key)->first())->uuid;
            default:
                return null;
        }
    }

    /**
     * @param string $room
     * @return array
     *
     * @author duc <1025434218@qq.com>
     */
    public static function getRoomUsers(string $room)
    {
        $driver = config('ws.auth.driver');

        switch ($driver) {
            case 'redis':
                $connection = config('ws.connection', 'default');

                $data = Redis::connection($connection)->hgetall(CacheKey::uuidUserMap($room));

                return @array_map('unserialize', $data);
            case 'mysql':
                return User::query()->where('room', $room)->get()->pluck('payload', 'uuid')->toArray();
            default:
                return null;
        }
    }

    /**
     * @param $key
     * @param string $room
     * @return mixed|null
     *
     * @author 神符 <1025434218@qq.com>
     */
    public static function getUserByKey($key, string $room)
    {
        $driver = config('ws.auth.driver');

        switch ($driver) {
            case 'redis':
                $connection = config('ws.connection', 'default');

                $uuid = static::getUuidByKey($key, $room);
                $data = Redis::connection($connection)->hget(CacheKey::uuidUserMap($room), $uuid);

                return $data ? @unserialize($data) : null;
            case 'mysql':
                $key = CacheKey::userKey($key);

                return optional(User::query()->where('room', $room)->where('key', $key)->first())->payload;
            default:
                return null;
        }
    }
}
