<?php

namespace Mainto\Websocket\Auth\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model
{
    use SoftDeletes;

    protected $table = 'websocket_access_users';

    protected $fillable = ['uuid', 'key', 'room', 'payload', 'expired_at'];

    protected $dates = [
        'expired_at',
    ];

    public function getPayloadAttribute($value)
    {
        return @unserialize($value);
    }

    public function setPayloadAttribute($value)
    {
        $this->attributes['payload'] = serialize($value);
    }

    public function loginExpired()
    {
        if (now()->isAfter($this->expired_at)) {
            $this->delete();

            return true;
        }

        return false;
    }
}
