<?php

return [
    /*
    |--------------------------------------------------------------------------
    | 合并响应内容
    |--------------------------------------------------------------------------
    |
    | 启用后会合并多个 response.
    |
    */
    'queued'             => false,
//    'ws_queued_data_key' => 'ws_queued_data',

    /*
    |--------------------------------------------------------------------------
    | context 注入
    |--------------------------------------------------------------------------
    |
    | 开启后可以在 app() 实例化对象时自动注入 context，深度 1.
    |
    */
    'context_injection'  => true,

    /*
    |--------------------------------------------------------------------------
    | redis 默认连接
    |--------------------------------------------------------------------------
    |
    */
    'connection'         => 'default',


    /*
    |--------------------------------------------------------------------------
    | 设置认证失败返回的 code 和 消息
    |--------------------------------------------------------------------------
    |
    |
    */
    'unauthorized'       => [
        'code'    => [
            'default' => 401,
        ],
        'message' => [
            'default' => 'unauthorized!',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | 认证驱动
    |--------------------------------------------------------------------------
    |
    | 可以使用 mysql 或者 redis 驱动.
    |
    */
    'auth'               => [
        // redis, mysql
        'driver' => env('WS_AUTH_DRIVER', 'redis'),
        // 过期时间 字符串或者 int(秒数)
        'expire' => env('WS_AUTH_EXPIRE', 'tomorrow'),
    ],
];
