<?php

namespace Mainto\Websocket\Auth;

use Illuminate\Support\Str;
use Mainto\Websocket\Contracts\AuthGuard;
use Mainto\RpcServer\RpcServer\RpcContext;
use Mainto\RpcServer\Exceptions\RpcRuntimeException;

/**
 * Class Manager
 * @package Mainto\Websocket\Auth
 * @mixin AuthGuard
 */
class Manager
{
    /**
     * @var RpcContext
     */
    public $context;

    /**
     * AuthGuard constructor.
     * @param RpcContext $context
     */
    public function __construct(RpcContext $context)
    {
        $this->context = $context;
    }

    /**
     * @return mixed
     *
     * @author 神符 <1025434218@qq.com>
     */
    public function driver()
    {
        $name = config('ws.auth.driver', 'redis');
        $method = 'create' . Str::studly($name) . 'driver';
        if (! method_exists($this, $method)) {
            throw new RpcRuntimeException("driver [$name] not support!");
        }

        return $this->{$method}($name);
    }

    /**
     * @param $name
     * @return RedisAuthProvider
     *
     * @author 神符 <1025434218@qq.com>
     */
    public function createRedisDriver($name)
    {
        return new RedisAuthProvider($this);
    }

    /**
     * @param $name
     * @return MysqlAuthProvider
     *
     * @author 神符 <1025434218@qq.com>
     */
    public function createMysqlDriver($name)
    {
        return new MysqlAuthProvider($this);
    }

    /**
     * @param $name
     * @param $arguments
     * @return bool
     *
     * @author 神符 <1025434218@qq.com>
     */
    public function __call($name, $arguments)
    {
        if ($name === 'login') {
            $user = $arguments[0];
            $user->setUuid($this->context->getUserId());

            if (! $user->getKey()) {
                return false;
            }
        }

        return $this->driver()->{$name}(...$arguments);
    }
}
