<?php

namespace Mainto\Websocket;

class CacheKey
{
    /**
     * @param string $room
     * @return string
     *
     * @author 神符 <1025434218@qq.com>
     */
    public static function uuidUserMap(string $room)
    {
        return sprintf('uuid_cache_key@room:%s', $room);
    }

    /**
     * @param string $room
     * @return string
     *
     * @author 神符 <1025434218@qq.com>
     */
    public static function keyUuidMap(string $room)
    {
        return sprintf('all_login_users@room:%s', $room);
    }

    /**
     * @param string $key
     * @return string
     *
     * @author 神符 <1025434218@qq.com>
     */
    public static function userKey(string $key)
    {
        return sprintf('user:%s', $key);
    }
}
