<?php


namespace Mainto\Websocket\Http;

use Illuminate\Support\Traits\ForwardsCalls;
use Mainto\RpcServer\RpcServer\RpcContext;
use Mainto\Websocket\Contracts\ValidatesWhenResolved;

/**
 * Class FormRequest
 * @package Mainto\Websocket
 * @mixin RpcContext
 */
abstract class FormRequest implements ValidatesWhenResolved {
    use ForwardsCalls;

    protected $request;

    public function __construct (RpcContext $request) {
        $this->request = $request;
    }

    /**
     * @inheritDoc
     */
    public function validateResolved () {
        $messages = [];
        if (method_exists($this,'messages')) {
            $messages = $this->messages();
        }

        validator($this->request->all(), $this->rules(), $messages)->validate();
    }

    abstract public function rules (): array;

    /**
     * Dynamically pass missing methods to the Swift instance.
     *
     * @param  string  $method
     * @param  array  $parameters
     * @return mixed
     */
    public function __call($method, $parameters)
    {
        return $this->forwardCallTo($this->request, $method, $parameters);
    }
}