<?php

namespace Mainto\Websocket\Auth;

use Mainto\Websocket\Contracts\Userable;
use Mainto\Websocket\Contracts\WithRoom;

/**
 * Class User
 * @package Mainto\Websocket\Auth
 */
abstract class User implements Userable, WithRoom
{
    /**
     * @var string
     */
    protected $uuid;

    /**
     * @var string|null
     */
    protected $key = null;

    /**
     * @var array
     */
    protected $attributes = [];

    /**
     * User constructor.
     * @param $key
     * @param array $attributes
     */
    public function __construct($key, array $attributes = [])
    {
        $this->key = $key;
        $this->attributes = $attributes;
    }

    /**
     * @param mixed $uuid
     * @return User
     */
    public function setUuid($uuid)
    {
        $this->uuid = $uuid;

        return $this;
    }

    /**
     * @return string
     */
    public function getUuid(): string
    {
        return $this->uuid;
    }

    /**
     * @return mixed
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * @param $name
     * @return mixed|null
     *
     * @author duc <1025434218@qq.com>
     */
    public function __get($name)
    {
        return $this->attributes[$name] ?? null;
    }

    /**
     * @return string
     *
     * @author duc <1025434218@qq.com>
     */
    abstract public static function bigRoom(): string;

    /**
     * @param $identifier
     * @return string
     *
     * @author duc <1025434218@qq.com>
     */
    abstract public static function room($identifier): string;
}
