<?php

namespace Mainto\Websocket\Events;

use Mainto\Websocket\Contracts\Userable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Broadcasting\InteractsWithSockets;

class ClearLastLoginInfo
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * @var Userable
     */
    public $user;

    /**
     * @var string
     */
    public $room;

    /**
     * Create a new event instance.
     *
     * @param Userable|null $user
     * @param string $room
     */
    public function __construct(?Userable $user, string $room)
    {
        $this->room = $room;
        $this->user = $user;
    }
}
