<?php

use DucCnzj\WsPhp\Auth\Manager;
use DucCnzj\WsPhp\Contracts\Response;
use Illuminate\Support\Facades\Redis;
use Mainto\RpcServer\RpcServer\RpcContext;

if (! function_exists('ws_response')) {
    /**
     * @return Response
     *
     * @author duc <1025434218@qq.com>
     */
    function ws_response()
    {
        return app(Response::class);
    }
}

if (! function_exists('ws_auth')) {
    /**
     * @param RpcContext $context
     * @return Manager
     * @author duc <1025434218@qq.com>
     */
    function ws_auth(RpcContext $context)
    {
        return app(Manager::class, ['context' => $context]);
    }
}

if (! function_exists('ws_get_uuid_by_key')) {
    /**
     * @param $key
     * @param string $room
     * @return string|null
     *
     * @author duc <1025434218@qq.com>
     */
    function ws_get_uuid_by_key($key, string $room)
    {
        $hasKey = sprintf('%s:%s', $room, 'all_login_users');
        $key = sprintf('user:%s', $key);

        return Redis::connection(config('ws.connection', 'default'))->hget($hasKey, $key) ?? null;
    }
}
