<?php

namespace DucCnzj\WsPhp;

use DucCnzj\WsPhp\Router\Router;
use Illuminate\Support\ServiceProvider;
use DucCnzj\WsPhp\Contracts\Response as ResponseImp;

class WebSocketServiceProvider extends ServiceProvider
{
    protected $defer = true;

    protected $routes = [];

    public function provides()
    {
        return ['ws_router', Response::class];
    }

    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->singleton(Router::class, function () {
            return new Router(...$this->routes);
        });

        $this->app->alias(Router::class, 'ws_router');

        $this->app->bind(ResponseImp::class, Response::class);
    }

    public function boot()
    {
        $this->registerRoutePath(base_path('routes/ws.php'));
    }

    protected function registerRoutePath(...$path)
    {
        $this->routes = array_merge($this->routes, $path);
    }
}
