<?php

namespace DucCnzj\WsPhp\Contracts;

use Mainto\RpcServer\RpcServer\RpcContext;

/**
 * Interface Response
 * @package DucCnzj\WsPhp\Contracts
 */
interface Response
{
    /**
     * @param RpcContext $context
     * @param $data
     * @param string $type
     * @param string $identifier
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function successBroadcast(RpcContext $context, $data, string $type = '', string $identifier = null);

    /**
     * @param RpcContext $context
     * @param $data
     * @param string $type
     * @param string $identifier
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function successToSelf(RpcContext $context, $data, string $type = '', string $identifier = null);

    /**
     * @param RpcContext $context
     * @param string $uuid
     * @param $data
     * @param string $type
     * @param string $identifier
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function successToUser(RpcContext $context, string $uuid, $data, string $type = '', string $identifier = null);

    /**
     * @param RpcContext $context
     * @param \Exception $exception
     * @param array $appends
     * @param string $type
     * @param string $identifier
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function errorBroadcast(RpcContext $context, \Exception $exception, array $appends = [], string $type = '', string $identifier = null);

    /**
     * @param RpcContext $context
     * @param \Exception $exception
     * @param array $appends
     * @param string $type
     * @param string $identifier
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function errorToSelf(RpcContext $context, \Exception $exception, array $appends = [], string $type = '', string $identifier = null);

    /**
     * @param RpcContext $context
     * @param string $uuid
     * @param \Exception $exception
     * @param array $appends
     * @param string $type
     * @param string $identifier
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function errorToUser(RpcContext $context, string $uuid, \Exception $exception, array $appends = [], string $type = '', string $identifier = null);

    /**
     * @param RpcContext $context
     * @param string $notifyType
     * @param string|null $uuid
     * @param array $payload
     * @param string $identifier
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function notifyUser(RpcContext $context, string $notifyType, string $uuid = null, array $payload = [], string $identifier = null);

    /**
     * @param RpcContext $context
     * @param string $notifyType
     * @param array $payload
     * @param string $identifier
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function notifyAll(RpcContext $context, string $notifyType, array $payload = [], string $identifier = null);

    /**
     * @param RpcContext $context
     * @param string $type
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function shouldNotAddReturn(RpcContext $context, string $type);

    /**
     * @param RpcContext $context
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function resetShouldAddReturn(RpcContext $context);

    /**
     * @param RpcContext $context
     * @param string $type
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function shouldAddReturn(RpcContext $context, string $type);

    /**
     * @param string $uuid
     * @param string $room
     * @param string $msg
     * @return mixed
     *
     * @author duc <1025434218@qq.com>
     */
    public function sendToUser(string $uuid, string $room, string $msg);

    /**
     * @param RpcContext $context
     * @param string $type
     * @return string
     *
     * @author duc <1025434218@qq.com>
     */
    public function parseType(RpcContext $context, string $type = ''): string;
}
