<?php

namespace DucCnzj\WsPhp\Router;

use Mainto\RpcServer\RpcServer\RpcContext;

/**
 * Class Router
 * @package App\Services
 */
class Router
{
    /**
     * @var array
     */
    protected $routes = [];

    /**
     * @var array
     */
    public $payload = [];

    /**
     * @var array
     */
    protected $groupMiddleware = [];

    /**
     * @var RpcContext
     */
    public $request;

    /**
     * Router constructor.
     * @param mixed ...$paths
     */
    public function __construct(...$paths)
    {
        foreach ($paths as $path) {
            if (file_exists($path)) {
                $this->loadRoutes($path);
            }
        }
    }

    /**
     * @param $request
     * @return $this
     *
     * @author duc <1025434218@qq.com>
     */
    public function setRequest($request)
    {
        $this->request = $request;

        return $this;
    }

    /**
     * @param mixed ...$payload
     * @return $this
     *
     * @author duc <1025434218@qq.com>
     */
    public function setPayload(...$payload)
    {
        $this->payload = $payload;

        return $this;
    }

    /**
     * @param string $room
     * @param string $type
     * @param string|\Closure $handler
     * @param null $method
     * @return Route
     *
     * @author duc <1025434218@qq.com>
     */
    public function register(string $room, string $type, $handler, $method = null)
    {
        $route = (new Route($room, $type, $handler, $this->groupMiddleware))
            ->setRouter($this)
            ->method($method);
        $this->routes[$room][$type] = $route;

        return $route;
    }

    /**
     * @param array $attributes
     *
     * @author duc <1025434218@qq.com>
     */
    protected function updateGroupStack(array $attributes)
    {
        $this->groupMiddleware[] = $attributes;
    }

    /**
     * @param array $middleware
     * @param $routes
     *
     * @author duc <1025434218@qq.com>
     */
    public function middleware(array $middleware, $routes)
    {
        $this->updateGroupStack($middleware);

        $this->loadRoutes($routes);

        array_pop($this->groupMiddleware);
    }

    /**
     * @param string $room
     * @param string $type
     * @return Route
     *
     * @throws \Exception
     * @author duc <1025434218@qq.com>
     */
    public function findRoute(string $room, string $type)
    {
        $route = $this->getRoutes($room)->get($type);
        if (! $route) {
            throw new \Exception('undefined type!');
        }

        return $route;
    }

    /**
     * @param string $room
     * @return \Illuminate\Support\Collection|Route[]
     *
     * @author duc <1025434218@qq.com>
     */
    public function getRoutes(string $room = null)
    {
        return collect(is_null($room) ? $this->routes : $this->routes[$room] ?? []);
    }

    /**
     * @param $routes
     *
     * @author duc <1025434218@qq.com>
     */
    public function loadRoutes($routes)
    {
        $router = $this;
        if (is_callable($routes)) {
            $routes($this);
        } else {
            require $routes;
        }
    }
}
