<?php
/**
 * TOP API: tmall.servicecenter.servicestore.createservicestorecapacity request
 * 
 * @author auto create
 * @since 1.0, 2018.07.25
 */
class TmallServicecenterServicestoreCreateservicestorecapacityRequest
{
	/** 
	 * 业务类型
	 **/
	private $bizType;
	
	/** 
	 * json格式，在某个业务类型(biz_type)下,类目所覆盖区域对应的容量。一个网点承接了空调和热水器的安装, 空调覆盖的区域是杭州市上城区和下城区，容量是10； 热水器覆盖的区域是杭州市下城区和江干区，容量是18；洗衣机和冰箱覆盖区域一样都是杭州市上城区和西湖区，合并计算容量30
	 **/
	private $categoryIdsAndAreaCodesAndCapacity;
	
	/** 
	 * serviceCodes列表,|分隔
	 **/
	private $serviceCodes;
	
	/** 
	 * 网点编码
	 **/
	private $serviceStoreCode;
	
	private $apiParas = array();
	
	public function setBizType($bizType)
	{
		$this->bizType = $bizType;
		$this->apiParas["biz_type"] = $bizType;
	}

	public function getBizType()
	{
		return $this->bizType;
	}

	public function setCategoryIdsAndAreaCodesAndCapacity($categoryIdsAndAreaCodesAndCapacity)
	{
		$this->categoryIdsAndAreaCodesAndCapacity = $categoryIdsAndAreaCodesAndCapacity;
		$this->apiParas["category_ids_and_area_codes_and_capacity"] = $categoryIdsAndAreaCodesAndCapacity;
	}

	public function getCategoryIdsAndAreaCodesAndCapacity()
	{
		return $this->categoryIdsAndAreaCodesAndCapacity;
	}

	public function setServiceCodes($serviceCodes)
	{
		$this->serviceCodes = $serviceCodes;
		$this->apiParas["service_codes"] = $serviceCodes;
	}

	public function getServiceCodes()
	{
		return $this->serviceCodes;
	}

	public function setServiceStoreCode($serviceStoreCode)
	{
		$this->serviceStoreCode = $serviceStoreCode;
		$this->apiParas["service_store_code"] = $serviceStoreCode;
	}

	public function getServiceStoreCode()
	{
		return $this->serviceStoreCode;
	}

	public function getApiMethodName()
	{
		return "tmall.servicecenter.servicestore.createservicestorecapacity";
	}
	
	public function getApiParas()
	{
		return $this->apiParas;
	}
	
	public function check()
	{
		
		RequestCheckUtil::checkNotNull($this->bizType,"bizType");
		RequestCheckUtil::checkNotNull($this->categoryIdsAndAreaCodesAndCapacity,"categoryIdsAndAreaCodesAndCapacity");
		RequestCheckUtil::checkNotNull($this->serviceCodes,"serviceCodes");
		RequestCheckUtil::checkNotNull($this->serviceStoreCode,"serviceStoreCode");
	}
	
	public function putOtherTextParam($key, $value) {
		$this->apiParas[$key] = $value;
		$this->$key = $value;
	}
}
