<?php
/**
 * TOP API: tmall.fuwu.serviceitem.list request
 * 
 * @author auto create
 * @since 1.0, 2018.07.25
 */
class TmallFuwuServiceitemListRequest
{
	/** 
	 * 商品id列表，有数量限制
	 **/
	private $itemids;
	
	/** 
	 * 商品所属卖家账号id
	 **/
	private $sellerId;
	
	private $apiParas = array();
	
	public function setItemids($itemids)
	{
		$this->itemids = $itemids;
		$this->apiParas["itemids"] = $itemids;
	}

	public function getItemids()
	{
		return $this->itemids;
	}

	public function setSellerId($sellerId)
	{
		$this->sellerId = $sellerId;
		$this->apiParas["seller_id"] = $sellerId;
	}

	public function getSellerId()
	{
		return $this->sellerId;
	}

	public function getApiMethodName()
	{
		return "tmall.fuwu.serviceitem.list";
	}
	
	public function getApiParas()
	{
		return $this->apiParas;
	}
	
	public function check()
	{
		
		RequestCheckUtil::checkMaxListSize($this->itemids,20,"itemids");
	}
	
	public function putOtherTextParam($key, $value) {
		$this->apiParas[$key] = $value;
		$this->$key = $value;
	}
}
