#!/bin/env php
<?php

use Illuminate\Support\Str;

require_once "./vendor/autoload.php";

// 75 is - size
function echoLine($content) {
    print "\033[32m| " . str_pad($content, 75, " ", STR_PAD_BOTH) . " |\033[0m\n";
}

$dirname = basename(getcwd());
$serverName = Str::studly($dirname);

system("sed -i 's/RPC_SERVER_NAME=Test/RPC_SERVER_NAME=$serverName/g' .env.example");
system("sed -i 's/RPC_SERVER_NAME=Test/RPC_SERVER_NAME=$serverName/g' .env.example.local");
system("sed -i 's/RPC_SERVER_NAME=Test/RPC_SERVER_NAME=$serverName/g' .env");
system("sed -i 's/name: service-php-template/name: $dirname/g' chart/Chart.yaml");
system("sed -i 's/description: Himo Micro Template/description: $serverName/g' chart/Chart.yaml");
system("sed -i 's/service_name: Test/service_name: $serverName/g' chart/values.yaml");

$gitlabCiYml = <<<EOF
.unit-test-var:
  variables:
    NONE: NONE

.deploy-to:dev-var:
  variables:
    CPU_REQUIRE: 50m
    CPU_LIMIT: 500m
    MEMORY_LIMIT: 256Mi
    MYSQL_MAIN_DATABASE: database
    MYSQL_MAIN_HOST: host.database
    MYSQL_MAIN_USERNAME: username
    MYSQL_MAIN_PASSWORD: 123456
    CACHE_DRIVER: array

.deploy-to:pre-var:
  extends: .deploy-to:dev-var
  variables:
    CPU_REQUIRE: 50m
    CPU_LIMIT: 500m
    MYSQL_MAIN_HOST: mainto-rw-pre.mysql.rds.aliyuncs.com
    MYSQL_MAIN_USERNAME: pre
    MYSQL_MAIN_PASSWORD: Al7ug0EvXxTG6hFK

.pages-var:
  extends: .unit-test-var

.deploy-to:stable-var:
  variables:
    CPU_REQUIRE: 100m
    CPU_LIMIT: 1000m
    MEMORY_LIMIT: 256Mi
    CACHE_DRIVER: redis

# https://code.hzmantu.com/mainto-tech-internal/ci-template/tree/master/php-service
include:
  - project: 'mainto-tech-internal/ci-template'
    ref: 'master'
    file: '/php-service/root.yaml'

EOF;

file_put_contents('./.gitlab-ci.yml', $gitlabCiYml);

echoLine(str_repeat("-", 75));
echoLine("init success.");
echoLine("");
echoLine("project name: ". $serverName);
echoLine("");
echoLine(str_repeat("-", 75));

unlink("./init.php");
