#!/bin/env php
<?php

use Illuminate\Support\Str;

require_once "./vendor/autoload.php";

// 75 is - size
function echoLine($content) {
    print "\033[32m| " . str_pad($content, 75, " ", STR_PAD_BOTH) . " |\033[0m\n";
}

fwrite(STDOUT, "Enter service name: ");
$serverName = Str::studly(trim(fgets(STDIN)));

function fileReplace($pattern, $replacement, $file) {
    $rep = preg_replace($pattern, $replacement, file_get_contents($file));
    file_put_contents($file, $rep);
}

fwrite(STDOUT, "enabled redis cache ? (y/n): ");
if (trim(fgets(STDIN)) == 'y' || trim(fgets(STDIN)) == 'Y' || trim(fgets(STDIN)) == 'yes') {
    $enabledRedis = true;
} else {
    $enabledRedis = false;
}

fileReplace('/RPC_SERVER_NAME=.*/', "RPC_SERVER_NAME=$serverName", ".env.example");
fileReplace('/RPC_SERVER_NAME=.*/', "RPC_SERVER_NAME=$serverName", ".env.example.local");
fileReplace('/application.service_name=.*/', "application.service_name=$serverName", ".helm.options");

if ($enabledRedis) {
    fileReplace('/redis.enable=.*/', "redis.enable=true", ".helm.options.ini");
}

$gitlabCiYml = <<<EOF
.unit-test-var:
  variables:
    APP_ENV: testing
    DOCKER_DRIVER: overlay2
    MICRO_DOC_ENABLE: 'true'
    DB_DATABASE: himo-middle-photo
    DB_HOST: mysql.mainto-dev.inc
    DB_USERNAME: root
    DB_PASSWORD: u4bVDgdvELq6Nmhb

.deploy-to:dev-var:
  variables:
    CPU_REQUIRE: 50m
    CPU_LIMIT: 500m
    MEMORY_LIMIT: 256Mi
    DB_DATABASE: database
    DB_HOST: host.database
    DB_USERNAME: username
    DB_PASSWORD: 123456
    CACHE_DRIVER: redis

.deploy-to:pre-var:
  extends: .deploy-to:dev-var
  variables:
    CPU_REQUIRE: 50m
    CPU_LIMIT: 500m
    MEMORY_LIMIT: 512Mi
    DB_HOST: mainto-rw-pre.mysql.rds.aliyuncs.com
    DB_USERNAME: pre
    DB_PASSWORD: Al7ug0EvXxTG6hFK

.pages-var:
  extends: .unit-test-var

.deploy-to:stable-var:
  variables:
    CPU_REQUIRE: 100m
    CPU_LIMIT: 1000m
    MEMORY_LIMIT: 512Mi
    CACHE_DRIVER: redis
    REDIS_MEMORY: 256Mi

# https://code.hzmantu.com/mainto-tech-internal/ci-template/tree/master/php-service
include:
  - project: 'mainto-tech-internal/ci-template'
    ref: 'master'
    file: '/php-service/root.yaml'

EOF;

file_put_contents('./.gitlab-ci.yml', $gitlabCiYml);

echoLine(str_repeat("-", 75));
echoLine("init success.");
echoLine("");
echoLine("project name: ". $serverName);
echoLine("");
echoLine(str_repeat("-", 75));

//unlink("./init.php");
