<?php


namespace App\Rpc\Controllers;


use App\Models\IntranetHashLog;
use App\Models\Photo\IntranetPhotoLog;
use GuzzleHttp\Client;
use Mainto\RpcServer\Base\Controller;
use Mainto\RpcServer\RpcAnnotations\Alias;
use Mainto\RpcServer\RpcAnnotations\RpcCron;


class TaskController extends Controller {

    /**
     * @Alias("自动结束冲量buff")
     *
     * @RpcCron(every="4s")
     */
    function autoEndImpulse () {
        IntranetPhotoLog::where('net_path', '')->orderBy('id')
            ->get()
            ->each(function (IntranetPhotoLog $photoLog) {
                /** @var IntranetHashLog $hashLog */
                $hashLog = $photoLog->intranetHashes->first();
                /** @var IntranetHashLog $hash */
                $hash = IntranetHashLog::whereNotNull('net_path')->where('uuid', $hashLog->uuid)->first();
                if (!$hash) {
                    return;
                }
                $client = new Client();
                if ($hash->id < $hashLog->id) {
                    $client->post("https://api-gateway.hzmantu.com/project_cloud/temple/bindIntIntranetPhotoHash", [
                        'json' => [
                            'hashLogIds' => [$hash->id, $hashLog->id],
                            'photoLogId' => $photoLog->id,
                        ],
                    ]);
                }
                $client->post("https://api-gateway.hzmantu.com/project_cloud/photoApi/finishIntranetPhoto", [
                    'json' => [
                        'Uuid'    => $hash->uuid,
                        'NetPath' => "upload/".$hash->net_path,
                    ],
                ]);
            });
    }


}
