<?php

namespace App\Models\Photo;

use App\Models\DateTimeFormat;
use App\Models\IntranetHashLog;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


/**
 * App\Models\Photo\IntranetPhotoLog
 *
 * @property int $id
 * @property string $state     状态
 * @property int $photo_id     照片id
 * @property string $task_hash 任务hash
 * @property string $file_hash 文件hash
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|mixed $stream_id
 * @property string $net_path
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetPhotoLog newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetPhotoLog newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetPhotoLog query()
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetPhotoLog whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetPhotoLog whereFileHash($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetPhotoLog whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetPhotoLog wherePhotoId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetPhotoLog whereState($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetPhotoLog whereTaskHash($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetPhotoLog whereUpdatedAt($value)
 * @mixin \Eloquent
 * @method static \Database\Factories\Photo\IntranetPhotoLogFactory factory(...$parameters)
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetPhotoLog whereNetPath($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetPhotoLog whereStreamId($value)
 * @property-read \Illuminate\Database\Eloquent\Collection|IntranetHashLog[] $intranetHashes
 * @property-read int|null $intranet_hash_count
 * @property-read int|null $intranet_hashes_count
 */
class IntranetPhotoLog extends Model {
    use HasFactory, DateTimeFormat;

    public function intranetHashes () {
        return $this->belongsToMany(IntranetHashLog::class,'intranet_hash_photo_relations', 'photo_log_id','hash_log_id');
    }
}
