<?php

namespace App\Models;

use App\Enums\Photo\IntranetPhotoStateEnum;
use App\Models\Photo\IntranetPhotoLog;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * App\Models\IntranetHashLog
 *
 * @property int $id
 * @property string $uuid          uuid
 * @property string|null $net_path 七牛云地址
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \Illuminate\Database\Eloquent\Collection|IntranetPhotoLog[] $intranetPhotos
 * @property-read int|null $intranet_photo_count
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetHashLog newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetHashLog newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetHashLog query()
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetHashLog whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetHashLog whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetHashLog whereNetPath($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetHashLog whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IntranetHashLog whereUuid($value)
 * @mixin \Eloquent
 * @property-read int|null $intranet_photos_count
 * @property-read \Illuminate\Database\Eloquent\Collection|IntranetPhotoLog[] $notFinishIntranetPhotos
 * @property-read int|null $not_finish_intranet_photos_count
 * @method static \Database\Factories\IntranetHashLogFactory factory(...$parameters)
 */
class IntranetHashLog extends Model {
    use HasFactory, DateTimeFormat;

    public function intranetPhotos () {
        return $this->belongsToMany(IntranetPhotoLog::class, 'intranet_hash_photo_relations', 'hash_log_id', 'photo_log_id');
    }

    public function notFinishIntranetPhotos () {
        return $this->belongsToMany(IntranetPhotoLog::class, 'intranet_hash_photo_relations', 'hash_log_id', 'photo_log_id')
            ->where('state', IntranetPhotoStateEnum::UPLOADING);
    }
}
