<?php


namespace Tests\Interfaces\ThirdPartyOrder\Controllers;


use App\Domain\ThirdPartyOrder\Service\CMCCApiService;
use Tests\TestCase;
use Mockery\MockInterface;
use Mainto\RpcServer\RpcUtil\RpcMessage;
use Mainto\Bridge\Invokes\User\User\User;
use Mainto\RpcTool\TestHelper\ControllerDoc;
use Illuminate\Foundation\Testing\DatabaseTransactions;
use Mainto\Bridge\Invokes\Preferential\GiftCard\GiftCardOrder;
use App\Interfaces\ThirdPartyOrder\Controllers\CMCCOrderController;

/**
 * Class CMCCOrderControllerTest
 * @package Tests\Interfaces\ThirdPartyOrder\Controllers
 *
 * --------------------------------------
 * auto gen method annotations, if the method name is already exists,
 * please use getResponse([method_name], [params])
 * --------------------------------------
 * @method callOpenRight(array $params = [], bool $enable_doc = true)
 * @method callOpenCallback(array $params = [], bool $enable_doc = true)
 */
class CMCCOrderControllerTest extends TestCase {
    use ControllerDoc, DatabaseTransactions;

    protected function getClass () {
        return CMCCOrderController::class;
    }

    public function setUp (): void {
        parent::setUp();
        $mock = \Mockery::mock('alias:'.RpcMessage::class);
        $mock->shouldReceive('getInstance->sendDelayMessage')->andReturnTrue();
        User::registerMock()->setValueMock('getUserId', mt_rand(1000, 9999));

        $createRes = [
            'buy_channel'   => 'store',
            'create_by'     => 89735698,
            'created_at'    => '2021-12-27 21:03:03',
            'extend'        => [
                'count'       => 2,
                'cover_id'    => 3804,
                'money'       => 200,
                'start_usage' => '2021-12-27 21:03:03',
                'stop_usage'  => '2022-03-27 21:03:03',
                'title'       => '测试产品卡创建记录title',
            ],
            'id'            => mt_rand(1000, 9999),
            'order_num'     => 'G2021122723717950',
            'ori_money'     => 500,
            'paid_at'       => '2021-12-27T21:03:03.000000Z',
            'pay_money'     => 300,
            'pay_type'      => 'offline_alipay',
            'phone'         => '17181364297',
            'sale_store_id' => 5866,
            'status'        => 'paid',
            'store_id'      => 1805,
            'type'          => 'virtual',
            'updated_at'    => '2021-12-27 21:03:03',
            'user_id'       => 30,
            'user_name'     => '池华',
        ];
        GiftCardOrder::registerMock()->setValueMock('managerCreate', $createRes);

        $info = [
            'id'            => 77951,
            'order_num'     => 'G2022010593261217',
            'store_id'      => 1075,
            'type'          => 'virtual',
            'user_name'     => 'www',
            'phone'         => '18170257563',
            'user_id'       => 12256541,
            'sex'           => 'male',
            'pay_type'      => 'enterprise',
            'payment_no'    => null,
            'ori_money'     => '100.00',
            'pay_money'     => '0.00',
            'status'        => 'paid',
            'create_by'     => 620690,
            'buy_channel'   => 'headquarters',
            'sale_store_id' => 1075,
            'invoice_id'    => null,
            'paid_at'       => '2022-01-05 17:18:28',
            'detail'        => null,
            'extend'        => [
                'count'       => 1,
                'money'       => '100',
                'title'       => '11',
                'cover_id'    => 3,
                'stop_usage'  => '2025-01-05 17:18:28',
                'approvalNum' => '12312',
                'start_usage' => '2022-01-05 17:18:28',
            ],
            'created_at'    => '2022-01-05 17:18:28',
            'updated_at'    => '2022-01-05 17:18:28',
            'items'         => [
                [
                    'id'         => 576000,
                    'order_id'   => 77951,
                    'card_id'    => 1220551,
                    'created_at' => '2022-01-05 17:18:28',
                    'updated_at' => '2022-01-05 17:18:28',
                    'card'       => [
                        'id'            => 1220551,
                        'user_id'       => null,
                        'cover_id'      => 3,
                        'code'          => '7REU7CQLQCWFRH6',
                        'create_log_id' => 10385,
                        'status'        => 'activated',
                        'money'         => '100.00',
                        'discount'      => 100,
                        'balance'       => '100.00',
                        'stop_usage'    => '2025-01-05 17:18:28',
                        'start_usage'   => '2022-01-05 17:18:28',
                        'activated_at'  => '2022-01-05 17:18:28',
                        'abolished_at'  => null,
                        'bind_at'       => null,
                        'old_id'        => 0,
                        'order_num'     => 'G2022010593261217',
                        'old_user_id'   => null,
                        'give_status'   => null,
                        'refund_id'     => null,
                        'created_at'    => '2022-01-05 17:18:28',
                        'updated_at'    => '2022-01-05 17:18:28',
                    ],
                ],
            ],
        ];
        GiftCardOrder::registerMock()->setValueMock('getInfo', $info);
    }

    public function testOpenRight () {
        $transactionId = 'transactionId';
        $reqTime = date('YmdHis').'000';
        $privateKey = '1';
        $params = [
            'contractRoot' => [
                'head' => [
                    'channelCode'   => 'channelCode',
                    'reqTime'       => $reqTime,
                    'apiId'         => 'apiId',
                    'transactionId' => $transactionId,
                ],
                'body' => [
                    'orderItemId' => 'CMCC1',
                    'rightsId'    => 'rightsId',
                    'serverNum'   => '18170257563',
                    'price'       => 100,
                    'quantity'    => 1,
                    'skuId'       => '123',
                    'skuCode'     => '124',
                    'skuName'     => '商品1',
                    'createTime'  => $reqTime,
                ],
            ],
        ];

        $body = array_filter($params['contractRoot']['body']);
        ksort($body);
        $sign = md5($transactionId.$reqTime.$privateKey.json_encode($body));
        $params['contractRoot']['head']['sign'] = $sign;
        $res = $this->callOpenRight($params);
        $this->assertIsString($res);
    }

    public function testOpenCallback () {
        $this->mock(CMCCApiService::class, function (MockInterface $mock) {
            $mock->makePartial();
            $mock->shouldReceive('openCallbackNotice')->andReturn(true);
        });

        $transactionId = 'transactionId';
        $reqTime = date('YmdHis').'000';
        $params = [
            'contractRoot' => [
                'head' => [
                    'channelCode'   => 'channelCode',
                    'reqTime'       => $reqTime,
                    'apiId'         => 'apiId',
                    'transactionId' => $transactionId,
                ],
                'body' => [
                    'orderItemId' => 'CMCC1',
                    'rightsId'    => 'rightsId',
                    'serverNum'   => '18170257563',
                    'price'       => 100,
                    'quantity'    => 1,
                    'skuId'       => '123',
                    'skuCode'     => '124',
                    'skuName'     => '商品1',
                    'createTime'  => $reqTime,
                ],
            ],
        ];
        $privateKey = '1';
        $body = array_filter($params['contractRoot']['body']);
        ksort($body);
        $sign = md5($transactionId.$reqTime.$privateKey.json_encode($body));
        $params['contractRoot']['head']['sign'] = $sign;
        $this->callOpenCallback($params);
    }
}