<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateThirdPartyOrderItems extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up () {
        Schema::create('third_party_order_items', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('third_id')->comment('第三方订单ID');
            $table->string('code', 16)->comment('券码');
            $table->json('extend')->comment('券码ID');
            $table->timestamps();

            $table->foreign('third_id')->on('third_party_orders')->references('id');

            $table->index(['code']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down () {
        Schema::dropIfExists('third_party_order_items');
    }
}
