<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateThirdPartyOrders extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up () {
        Schema::create('third_party_orders', function (Blueprint $table) {
            $table->id();
            $table->string('third_order_id', 32)->comment('第三方平台订单ID');
            $table->string('phone', 20)->comment('充值号码');
            $table->decimal('price', 10)->comment('价格');
            $table->string('third_type', 32)->comment('第三方订单类型');
            $table->unsignedInteger('user_id')->comment('用户ID');
            $table->unsignedInteger('count')->comment('数量');
            $table->string('sku_id', 32)->comment('商品 sku id');
            $table->json('extend')->comment('扩展信息');
            $table->timestamps();

            $table->index(['third_order_id', 'third_type']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down () {
        Schema::dropIfExists('third_party_orders');
    }
}
