<?php


namespace App\Interfaces\ThirdPartyOrder\DTO;


use Mainto\RpcServer\RpcServer\RpcObject;

/**
 * Class CMCCOpenRightHeadDTO
 * @package App\Interfaces\ThirdPartyOrder\DTO
 */
class CMCCOpenRightHeadDTO extends RpcObject {

    /** @var string 请求时间 */
    public string $reqTime;

    /** @var string 签名值 */
    public string $sign;

    /** @var string 请求流水号 */
    public string $transactionId;

    public static function from (string $transactionId, string $sign, string $reqTime) {
        $dto = new self();
        $dto->sign = $sign;
        $dto->transactionId = $transactionId;
        $dto->reqTime = $reqTime;

        return $dto;
    }

}