<?php


namespace App\Interfaces\ThirdPartyOrder\DTO;


use Mainto\RpcServer\RpcServer\RpcObject;

/**
 * Class CMCCOpenRightDTO
 * @package App\Interfaces\ThirdPartyOrder\DTO
 */
class CMCCOpenRightDTO extends RpcObject {

    /** @var CMCCOpenRightContractDTO $contract */
    public CMCCOpenRightContractDTO $contractRoot;

    /**
     * @param string $transactionId
     * @param string $reqTime
     * @param string $sign
     * @param CMCCOpenRightBodyDTO $bodyDto
     * @return CMCCOpenRightDTO
     */
    public static function from (string $transactionId, string $sign, string $reqTime, CMCCOpenRightBodyDTO $bodyDto): CMCCOpenRightDTO {
        $headDto = new CMCCOpenRightHeadDTO();
        $headDto->sign = $sign;
        $headDto->transactionId = $transactionId;
        $headDto->reqTime = $reqTime;

        $dto = new self();
        $dto->contractRoot = CMCCOpenRightContractDTO::from($headDto, $bodyDto);

        return $dto;
    }

    /**
     * @return string
     */
    public function toJson (): string {
        return json_encode([
            'contractRoot' => [
                'head' => get_object_vars($this->contractRoot->head),
                'body' => get_object_vars($this->contractRoot->body),
            ],
        ], JSON_UNESCAPED_UNICODE);
    }
}