<?php


namespace App\Interfaces\ThirdPartyOrder\DTO;


use Mainto\RpcServer\RpcServer\RpcObject;

/**
 * Class CMCCOpenRightContractDTO
 * @package App\Interfaces\ThirdPartyOrder\DTO
 */
class CMCCOpenRightContractDTO extends RpcObject {

    /** @var CMCCOpenRightBodyDTO */
    public CMCCOpenRightBodyDTO $body;

    /** @var CMCCOpenRightHeadDTO */
    public CMCCOpenRightHeadDTO $head;

    /**
     * @param CMCCOpenRightHeadDTO $head
     * @param CMCCOpenRightBodyDTO $body
     * @return CMCCOpenRightContractDTO
     */
    public static function from (CMCCOpenRightHeadDTO $head, CMCCOpenRightBodyDTO $body): CMCCOpenRightContractDTO {
        $dto = new self();
        $dto->body = $body;
        $dto->head = $head;

        return $dto;
    }
}