<?php


namespace App\Interfaces\ThirdPartyOrder\DTO;


use Mainto\RpcServer\RpcServer\RpcObject;

/**
 * Class CMCCOpenRightBodyDTO
 * @package App\Interfaces\ThirdPartyOrder\DTO
 */
class CMCCOpenRightBodyDTO extends RpcObject {

    /** @var string $resultMsg */
    public string $resultMsg;

    /** @var string $resultCode */
    public string $resultCode;

    /**
     * @param string $resultMsg
     * @param string $resultCode
     * @return CMCCOpenRightBodyDTO
     */
    public static function from (string $resultMsg, string $resultCode) {
        $dto = new self();
        $dto->resultCode = $resultCode;
        $dto->resultMsg = $resultMsg;

        return $dto;
    }

    /**
     * @return string
     */
    public function toJson (): string {
        return collect(get_object_vars($this))->toJson();
    }
}