<?php


namespace App\Interfaces\ThirdPartyOrder\Controllers\Impl;


use DB;
use Mainto\RpcServer\Base\Controller;
use Mainto\RpcServer\RpcServer\RpcContext;
use App\Domain\ThirdPartyOrder\Cmd\CMCCSignCmd;
use App\Domain\ThirdPartyOrder\Cmd\CMCCOpenRightCmd;
use App\Domain\ThirdPartyOrder\Service\CMCCApiService;
use App\Domain\ThirdPartyOrder\Service\CMCCOrderService;
use App\Domain\ThirdPartyOrder\Enum\CMCCOpenRightCodeEnum;
use App\Domain\ThirdPartyOrder\Exception\CMCCOrderException;
use App\Domain\ThirdPartyOrder\Translator\ThirdPartyOrderToCMCCCmd;
use App\Domain\ThirdPartyOrder\Model\Repository\ThirdPartyOrderRepository;
use App\Infrastructure\Bridge\User\UserBridge;
use App\Interfaces\ThirdPartyOrder\Cmd\CMCCOrderCmd;
use App\Infrastructure\Bridge\CMCC\Setting\CMCCSetting;
use App\Interfaces\ThirdPartyOrder\DTO\CMCCOpenRightDTO;
use App\Interfaces\ThirdPartyOrder\DTO\CMCCOpenRightBodyDTO;


class CMCCOrderController extends Controller implements \App\Interfaces\ThirdPartyOrder\Controllers\CMCCOrderController {

    /**
     * 开通权限
     * @param CMCCOrderCmd $orderCmd
     * @return string
     * @throws \Exception
     */
    public function openRight (CMCCOrderCmd $orderCmd): string {
        if ($orderCmd->contractRoot->body->skuCode != CMCCSetting::newInstance()->skuCode) {
            $bodyDto = CMCCOpenRightBodyDTO::from('开通失败', CMCCOpenRightCodeEnum::FAIL);
        } else {
            try {
                app(CMCCOrderService::class)->openRight($orderCmd->toCMCCSignCmd(), $orderCmd->toCMCCOrderCmd());
                $bodyDto = CMCCOpenRightBodyDTO::from('开通中，待回调', CMCCOpenRightCodeEnum::OPEN_WAITING);
            } catch (CMCCOrderException $exception) {
                $bodyDto = CMCCOpenRightBodyDTO::from('开通失败', CMCCOpenRightCodeEnum::FAIL);
            }
        }

        // 签名
        $reqTime = date('YmdHis').'000';
        $sign = app(CMCCApiService::class)->makeSign(CMCCSignCmd::from($orderCmd->contractRoot->head->transactionId, $reqTime, $bodyDto->toJson()), CMCCSetting::newInstance()->rightPrivateKey);

        return CMCCOpenRightDTO::from($orderCmd->contractRoot->head->transactionId, $sign, $reqTime, $bodyDto)->toJson();
    }

    /**
     * 权益开通回调
     * @param RpcContext $context
     * @param CMCCOpenRightCmd $orderCmd
     * @return bool
     * @throws \Throwable
     */
    public function openCallback (RpcContext $context, CMCCOpenRightCmd $orderCmd): bool {
        // 获取用户信息
        $userId = app(UserBridge::class)->getUserId($orderCmd->contractRoot->body->serverNum);
        $orderEntity = $orderCmd->toThirdPartyOrderEntity($userId);

        // 检测该订单是否已经发码
        $itemsCount = app(ThirdPartyOrderRepository::class)->getItemsCountByThirdTypeOrder($orderEntity->thirdOrderId, $orderEntity->thirdType);
        if ($itemsCount > 0) {
            return false;
        }

        return DB::transaction(function() use ($orderEntity, $orderCmd, $context) {
            // 制作券码
            app(CMCCOrderService::class)->openCallback($orderEntity);
            // 拼接数据
            $rootCmd = app(ThirdPartyOrderToCMCCCmd::class)->toCMCCOpenCallbackCmd($orderCmd, $orderEntity);

            // 请求接口
            return app(CMCCApiService::class)->openCallbackNotice($rootCmd, $context->getTraceId());
        });
    }
}