<?php

namespace App\Interfaces\ThirdPartyOrder\Controllers;

use App\Domain\ThirdPartyOrder\Cmd\CMCCOpenRightCmd;
use Mainto\RpcServer\RpcAnnotations\Alias;
use Mainto\RpcServer\RpcServer\RpcContext;
use Mainto\RpcServer\RpcAnnotations\RpcApi;
use Mainto\RpcServer\RpcAnnotations\RpcFormat;
use Mainto\RpcServer\RpcAnnotations\RpcMessageHook;
use App\Interfaces\ThirdPartyOrder\Cmd\CMCCOrderCmd;

interface CMCCOrderController {

    /**
     * CMCC 调用海马体，告知响应创建礼品卡的参数
     * @Alias(name="权益开通接口")
     * @RpcApi(method="POST", url="/cmcc/notify")
     * @RpcFormat(format="Raw")
     *
     * @param CMCCOrderCmd $orderCmd
     * @return string
     */
    public function openRight (CMCCOrderCmd $orderCmd): string;

    /**
     * @Alias(name="权益回调接口")
     * @RpcMessageHook(name="thirdProxy.cmcc.makeCode")
     * @RpcFormat(format="Raw")
     *
     * @param RpcContext $context
     * @param CMCCOpenRightCmd $orderCmd
     * @return bool
     */
    public function openCallback(RpcContext $context, CMCCOpenRightCmd $orderCmd): bool;
}
