<?php


namespace App\Interfaces\ThirdPartyOrder\Cmd;


use App\Domain\ThirdPartyOrder\Cmd\CMCCOpenRightCmd;
use Mainto\RpcServer\RpcServer\RpcObject;
use App\Domain\ThirdPartyOrder\Cmd\CMCCSignCmd;

/**
 * Class CMCCOrderCmd
 * @package App\Interfaces\ThirdPartyOrder\Cmd
 */
class CMCCOrderCmd extends RpcObject {

    /** @var CMCCOrderContractCmd 中国移动对接传递的参数 */
    public CMCCOrderContractCmd $contractRoot;

    /**
     * 拼接签名参数
     * @return CMCCSignCmd
     */
    public function toCMCCSignCmd (): CMCCSignCmd {
        $CMCCSignCmd = new CMCCSignCmd();
        $CMCCSignCmd->apiId = $this->contractRoot->head->apiId;
        $CMCCSignCmd->channelCode = $this->contractRoot->head->channelCode;
        $CMCCSignCmd->reqTime = $this->contractRoot->head->reqTime;
        $CMCCSignCmd->sign = $this->contractRoot->head->sign;
        $CMCCSignCmd->transactionId = $this->contractRoot->head->transactionId;
        $CMCCSignCmd->body = $this->contractRoot->body->toJson();

        return $CMCCSignCmd;
    }

    /**
     * @return array
     */
    public function toArray (): array {
        return [
            'contractRoot' => [
                'head' => get_object_vars($this->contractRoot->head),
                'body' => get_object_vars($this->contractRoot->body),
            ],
        ];
    }

    /**
     * @return CMCCOpenRightCmd
     */
    public function toCMCCOrderCmd (): CMCCOpenRightCmd {
        return tap(new CMCCOpenRightCmd(),
            function ($object) {
                return app('json_mapper')->map($this->toArray(), $object);
            });
    }
}