<?php


namespace App\Interfaces\ThirdPartyOrder\Cmd;


use Mainto\RpcServer\RpcServer\RpcObject;

/**
 * Class CMCCOrderBodyCmd
 * @package App\Interfaces\ThirdPartyOrder\Cmd
 */
class CMCCOrderBodyCmd extends RpcObject {

    /** @var string 权益方ID */
    public string $rightsId;

    /** @var string skuId */
    public string $skuId;

    /** @var string sku名称 */
    public string $skuName;

    /** @var string 创建时间 yyyyMMddHHmmssSSS */
    public string $createTime;

    /** @var string 子订单号 */
    public string $orderItemId;

    /** @var string 充值号码 */
    public string $serverNum;

    /** @var int sku价格，单位：分 */
    public int $price;

    /** @var int 数量 */
    public int $quantity;

    /** @var string 权益侧sku编码 */
    public string $skuCode;

    public function toJson () {
        return json_encode($this);
    }
}