<?php


namespace App\Infrastructure\Persistence\Repository;


use App\Domain\ThirdPartyOrder\Model\VO\ThirdPartyOrderIdVO;
use DB;
use Illuminate\Support\Collection;
use App\Infrastructure\Persistence\PO\ThirdPartyOrderPO;
use App\Domain\ThirdPartyOrder\Model\Entity\ThirdPartyOrderEntity;
use App\Domain\ThirdPartyOrder\Model\Entity\ThirdPartyOrderItemEntity;
use App\Domain\ThirdPartyOrder\Model\Repository\ThirdPartyOrderItemRepository;

class ThirdPartyOrderRepository implements \App\Domain\ThirdPartyOrder\Model\Repository\ThirdPartyOrderRepository {

    /**
     * @param ThirdPartyOrderEntity $orderEntity
     * @return bool
     * @throws \Throwable
     */
    public function save (ThirdPartyOrderEntity $orderEntity): bool {
        $model = ThirdPartyOrderPO::fromEntity($orderEntity);
        $model->saveOrFail();
        $orderEntity->updatedAt = $model->updated_at;
        $orderEntity->createdAt = $model->created_at;
        $orderEntity->orderIdVO = new ThirdPartyOrderIdVO($model->id);

        return true;
    }

    /**
     * @param ThirdPartyOrderEntity $orderEntity
     * @param Collection $thirdPartyOrderItemEntities
     * @return bool
     * @throws \Throwable
     */
    public function createThirdPartyOrderCodes (ThirdPartyOrderEntity $orderEntity, Collection $thirdPartyOrderItemEntities): bool {
        DB::transaction(function () use ($orderEntity, $thirdPartyOrderItemEntities) {
            $thirdPartyOrderItemEntities->each(function (ThirdPartyOrderItemEntity $itemEntity) {
                app(ThirdPartyOrderItemRepository::class)->save($itemEntity);
            });
            $this->save($orderEntity);
        });

        return true;
    }

    /**
     * @param string $thirdOrderId
     * @param string $thirdType
     * @return int
     */
    public function getItemsCountByThirdTypeOrder (string $thirdOrderId, string $thirdType): int {
        /** @var ThirdPartyOrderPO $thirdOrder */
        $thirdOrder = ThirdPartyOrderPO::where(['third_order_id' => $thirdOrderId, 'third_type' => $thirdType])->with('orderItems')->first();

        return $thirdOrder ? $thirdOrder->orderItems()->count() : 0;
    }
}