<?php


namespace App\Infrastructure\Persistence\Repository;


use App\Infrastructure\Persistence\PO\ThirdPartyOrderItemPO;
use App\Domain\ThirdPartyOrder\Model\Entity\ThirdPartyOrderItemEntity;
use Illuminate\Support\Collection;

class ThirdPartyOrderItemRepository implements \App\Domain\ThirdPartyOrder\Model\Repository\ThirdPartyOrderItemRepository {

    /**
     * @param Collection<ThirdPartyOrderItemEntity> $itemEntities
     * @return bool
     * @throws \Throwable
     */
    public function batchSave (Collection $itemEntities): bool {
        $itemEntities->each(function (ThirdPartyOrderItemEntity $itemEntity) {
            $model = ThirdPartyOrderItemPO::fromEntity($itemEntity);
            $model->saveOrFail();
            $itemEntity->updatedAt = $model->updated_at;
            $itemEntity->createdAt = $model->created_at;
        });

        return true;
    }
}