<?php


namespace App\Infrastructure\Persistence\PO;


use App\Domain\ThirdPartyOrder\Model\Entity\ThirdPartyOrderEntity;
use Illuminate\Database\Eloquent\Model;

/**
 * App\Infrastructure\Persistence\PO\ThirdPartyOrderPO
 *
 * @property int $id
 * @property string $third_order_id 第三方平台订单ID
 * @property string $phone          充值号码
 * @property string $price          价格
 * @property int $user_id           用户ID
 * @property int $count             数量
 * @property string $sku_id         商品 sku id
 * @property mixed $extend          扩展信息
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderPO newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderPO newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderPO query()
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderPO whereCount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderPO whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderPO whereExtend($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderPO whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderPO wherePhone($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderPO wherePrice($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderPO whereSkuId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderPO whereThirdOrderId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderPO whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderPO whereUserId($value)
 * @mixin \Eloquent
 * @property string $third_type     第三方订单类型
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderPO whereThirdType($value)
 * @property-read \Illuminate\Database\Eloquent\Collection|\App\Infrastructure\Persistence\PO\ThirdPartyOrderItemPO[] $orderItems
 * @property-read int|null $order_items_count
 */
class ThirdPartyOrderPO extends Model {

    public $table = 'third_party_orders';

    protected $casts = ['extend' => 'array'];

    public function orderItems () {
        return $this->hasMany(ThirdPartyOrderItemPO::class, 'third_id', 'id');
    }

    public static function fromEntity (ThirdPartyOrderEntity $orderEntity): ThirdPartyOrderPO {
        $model = new self();
        $model->third_order_id = $orderEntity->thirdOrderId;
        $model->phone = $orderEntity->phone;
        $model->price = $orderEntity->price;
        $model->user_id = $orderEntity->userId;
        $model->count = $orderEntity->count;
        $model->sku_id = $orderEntity->skuId;
        $model->third_type = $orderEntity->thirdType;
        $model->extend = $orderEntity->extend->toArray();

        return $model;
    }
}