<?php


namespace App\Infrastructure\Persistence\PO;


use App\Domain\ThirdPartyOrder\Model\Entity\ThirdPartyOrderItemEntity;
use Illuminate\Database\Eloquent\Model;

/**
 * App\Infrastructure\Persistence\PO\ThirdPartyOrderItemPO
 *
 * @property int $id
 * @property string $code 券码
 * @property mixed $extend 券码ID
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderItemPO newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderItemPO newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderItemPO query()
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderItemPO whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderItemPO whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderItemPO whereExtend($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderItemPO whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderItemPO whereThirdOrderId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderItemPO whereUpdatedAt($value)
 * @mixin \Eloquent
 * @property int $third_id 第三方订单ID
 * @method static \Illuminate\Database\Eloquent\Builder|ThirdPartyOrderItemPO whereThirdId($value)
 */
class ThirdPartyOrderItemPO extends Model {

    public $table = 'third_party_order_items';

    protected $casts = ['extend' => 'array'];

    public static function fromEntity (ThirdPartyOrderItemEntity $itemEntity): ThirdPartyOrderItemPO {
        $model = new self();
        $model->third_id = $itemEntity->thirdId->value();
        $model->code = $itemEntity->code;
        $model->extend = $itemEntity->extend->toArray();

        return $model;
    }
}