<?php
// +----------------------------------------------------------------------
// | 
// +----------------------------------------------------------------------
// | author    武安y<yaobin24@126.com>
// +----------------------------------------------------------------------
// | note
// +----------------------------------------------------------------------
// | Date       2021/8/17 2:38 下午
// +----------------------------------------------------------------------

namespace App\Infrastructure\Console\DomainWheel;

use Illuminate\Support\Str;

trait MakeWheelTools {
    /**
     * 设置实体方法
     * @var string
     */
    protected $setEntityProperty = '
    /**
     * description
     * @var docType 
     */
    public type $variableName;';

    /**
     * 设置实体方法
     * @var string
     */
    protected $setEntityPropertyWithDefult = '
    /**
     * description
     * @var docType 
     */
    public ?type $variableName = null;';


    protected $toEntity = '
    public function toEntity(): EntityClass {
        $entity = new EntityClass();
        $entity->id = new EntityVO($this->id);
%s
        return $entity;
    }
';


    protected $fromEntity = '
    public static function fromEntity(EntityClass $entity): POClass {
        $model = new self();
        if ($entity->id) {
            $model->id = $entity->id->value();
        }
%s
        return $model;
    }
';

    /**
     * Build the directory for the class if necessary.
     *
     * @param string $path
     * @return string
     */
    protected function makeDirectory (string $path): string {
        if (!is_dir($path)) {
            return @mkdir($path, 0777, true);
        }
        return $path;
    }


    /**
     * 获取领域的命名空间
     *
     * @param string $domain
     * @return $this
     */
    protected function domainEntityNameSpace (string $domain): string {
        return sprintf("App\\Domain\\%s\\Model\\Entity", $domain);
    }


    /**
     * 获取领域的命名空间
     *
     * @param string $domain
     * @return $this
     */
    protected function domainVONameSpace (string $domain): string {
        return sprintf("App\\Domain\\%s\\Model\\VO", $domain);
    }

    /**
     * @param string $po
     * @return string
     */
    protected function poNameSpace (string $po): string {
        return sprintf('App\\Infrastructure\\Persistence\\PO\\%s', $po);
    }


    /**
     * Replace the namespace for the given stub.
     *
     * @param string $stub
     * @param string $nameSpace
     * @return self
     */
    protected function replaceNamespace (string &$stub, string $nameSpace): self {
        $stub = str_replace(
            'DummyNamespace',
            $nameSpace,
            $stub
        );
        return $this;
    }

    /**
     * Replace the class name for the given stub.
     *
     * @param string $stub
     * @param string $className
     * @return self
     */
    protected function replaceClass (string &$stub, string $className): self {
        $stub = str_replace('DummyClass', $className, $stub);
        return $this;
    }

    /**
     * Replace the class name for the given stub.
     *
     * @param string $stub
     * @param string $className
     * @return self
     */
    protected function replacePO (string &$stub, string $poName): self {
        $stub = str_replace('NamespacedDummyPO', $poName, $stub);
        return $this;
    }

    /**
     * Replace the class name for the given stub.
     *
     * @param string $stub
     * @param string $findProperty
     * @param string $replaceProperty
     * @return self
     */
    protected function replaceProperty (string &$stub, string $findProperty, string $replaceProperty): self {
        $stub = str_replace($findProperty, $replaceProperty, $stub);
        return $this;
    }


    /**
     * @param array $property
     * @return string
     */
    protected function entityProperty (array $property): string {
        if ($property['defaultNull']) {
            $setEntityProperty = $this->setEntityPropertyWithDefult;
        } else {
            $setEntityProperty = $this->setEntityProperty;
        }
        return str_replace(
                ['description', 'docType', 'type', 'variableName'],
                [$property['description'], $property['docType'], $property['type'], $property['variableName']],
                $setEntityProperty
            ).PHP_EOL;

    }


    /**
     * @param string $property
     * @return string
     */
    protected function toEntityString (string $property): string {
        $entity = lcfirst($this->entity.'Entity');
        $poProperty = Str::snake($property);
        return "        $".$entity."->{$property} =".'$this->'."{$poProperty}; ".PHP_EOL;
    }

    /**
     * @param string $property
     * @return string
     */
    protected function fromEntityString (string $property): string {
        $entity = lcfirst($this->entity.'Entity');
        $poProperty = Str::snake($property);
        return '        $model->'.$poProperty.' = $'."$entity->{$property};" .PHP_EOL;
    }

    /**
     * @param string $propertyString
     * @return string
     */
    protected function toEntity (string $propertyString): string {
        $entityName = $this->entity.'Entity';
        $toEntityString = str_replace(
                ['EntityClass', 'entity', 'EntityVO'],
                [$entityName, lcfirst($entityName), $this->voName],
                $this->toEntity
            ).PHP_EOL;
        return sprintf($toEntityString, $propertyString);

    }

    /**
     * @param string $propertyString
     * @return string
     */
    protected function fromEntity (string $propertyString): string {
        $entityName = $this->entity.'Entity';
        $fromEntityString = str_replace(
                ['EntityClass', 'entity', 'POClass'],
                [$entityName, lcfirst($entityName), $this->entity],
                $this->fromEntity
            ).PHP_EOL;
        return sprintf($fromEntityString, $propertyString);

    }

    /**
     * Write the contents of a file.
     *
     * @param string $path
     * @param string $contents
     * @param bool $lock
     * @return int
     */
    protected function put ($path, $contents, $lock = false): int {
        return file_put_contents($path, $contents, $lock ? LOCK_EX : 0);
    }

}