<?php

namespace App\Infrastructure\Console\DomainWheel;

/**
 * 创建文件夹
 * Class MakeFolder
 * @package App\Console\DomainWheel
 */
class MakeFolder implements MakeWheel {
    use MakeWheelTools;

    protected string $domain;

    protected const DomainNameSpace = 'Domain';

    protected const InterfacesNameSpace = 'Interfaces';

    protected const PoFolder = '/Infrastructure/Persistence/PO';

    public function __construct (string $domain) {
        $this->domain = $domain;
    }

    /**
     * 构建数据
     */
    public function build () {
        $this->buildDomain()->buildInterfaces();
        return $this;
    }

    /**
     * @return string
     */
    public function getDomainEntityFolder (): string {
        $basicPath = app_path().'/'.self::DomainNameSpace;
        $domain = $basicPath.'/'.$this->domain;
        return $domain.'/Model/Entity';
    }

    /**
     * @return string
     */
    public function getDomainVOFullFolder (): string {
        $basicPath = app_path().'/'.self::DomainNameSpace;
        $domain = $basicPath.'/'.$this->domain;
        return $domain.'/Model/VO';
    }


    /**
     * @return string
     */
    public function getEntityPoFullFolder (): string {
        return app_path().'/'.self::PoFolder;
    }

    /**
     * @return MakeFolder
     */
    private function buildDomain (): MakeFolder {
        $basicPath = app_path().'/'.self::DomainNameSpace;
        $domain = $basicPath.'/'.$this->domain;
        $this->makeDirectory($domain);
        $folders = [
            'Enums',
            'Mapper',
            'Model' => [
                'Entity',
                'Repository',
                'VO',
            ],
            'Services',
        ];
        $this->buildFolders($domain, $folders);
        return $this;
    }

    /**
     * @return MakeFolder
     */

    private function buildInterfaces (): MakeFolder {
        $basicPath = app_path().'/'.self::InterfacesNameSpace;
        $domain = $basicPath.'/'.$this->domain;
        $this->makeDirectory($domain);
        $folders = [
            'Command',
            'Controllers',
            'DTO',
            'Translator',
        ];

        $this->buildFolders($domain, $folders);
        return $this;
    }


    private function buildFolders (string $basicPath, array $folderList) {
        foreach ($folderList as $folderKey => $folder) {
            if (is_array($folder)) {
                $this->buildFolders($basicPath.'/'.$folderKey, $folder);
                continue;
            }
            $this->makeDirectory($basicPath.'/'.$folder);
        }
    }

}