<?php

namespace App\Infrastructure\Console\Commands;

use App\Infrastructure\Console\DomainWheel\MakeEntity;
use App\Infrastructure\Console\DomainWheel\MakeFolder;
use Illuminate\Console\Command;
use Psy\Exception\RuntimeException;

class DomainWheel extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'domain {domainName? : 待初始化的领域数据}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '创建Domain相关的轮子';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return void
     */
    public function handle () {
        if (!$domain = $this->argument('domainName')) {
            $this->error(PHP_EOL."请输入需要执行的Domain的数据".PHP_EOL);
            return;
        }

        $wheel = $this->choice('想要执行的功能?', ['folder', 'entity']);

        $this->$wheel($domain);

    }


    /**
     * @param $name
     * @param $arguments
     * @return void
     */
    public function __call ($name, $arguments) {
        $method = 'wheel'.ucfirst($name);
        if (!method_exists($this, $method)) {
            $this->error(PHP_EOL."该方法暂时无法提供支持".PHP_EOL);
            return;
        }
        try {
            $this->$method($arguments[0]);
        } catch (\Exception $exception) {
            $this->error(PHP_EOL."{$exception->getMessage()}");
        }
        return;
    }

    public function wheelFolder (string $domain) {
        (new MakeFolder($domain))->build();
    }


    public function wheelEntity (string $domain) {
        $entity = $this->ask("请输入你需要添加实体的所实体");

        $domainFolderFullPath = (new MakeFolder($domain))->getDomainEntityFolder();
        if (!is_dir($domainFolderFullPath)) {
            throw new RuntimeException('实体的所属领域不存在，请先创建相关文件夹');
        }
        (new MakeEntity($domain, $entity))->setEntityFolderFullPath($domainFolderFullPath)->build();
    }
}
