<?php


namespace App\Infrastructure\Bridge\Preferential;


use Mainto\Bridge\Invokes\Preferential\GiftCard\GiftCardOrder;

class GiftCardBridge {

    /**
     * 生成礼品卡
     * @param array $orderCmd
     * @return array
     */
    public function createGiftCard (array $orderCmd): array {
        return GiftCardOrder::getDirectClass()->managerCreateByParams($orderCmd);
    }

    /**
     * 获取礼品卡信息
     * @param int $id
     * @return array
     */
    public function getCardsInfo (int $id): array {
        return GiftCardOrder::getDirectClass()->getInfoByParams(['id' => $id]);
    }
}